function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = GK_financial.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(71, 119);
g1(1,24)=(-T(5));
g1(1,63)=1;
g1(1,110)=(-T(7));
g1(2,22)=1;
g1(2,93)=(-T(7));
g1(2,24)=T(53);
g1(3,23)=1;
g1(3,94)=(-T(7));
g1(3,24)=T(53);
g1(3,39)=params(34)*2*(y(39)-(steady_state(18)));
g1(4,24)=1;
g1(4,1)=(-(T(10)*T(56)*T(57)/(1-params(6))));
g1(4,25)=(-(T(10)*T(57)/(1-params(6))));
g1(4,26)=(-(T(9)*T(62)));
g1(5,2)=(-((1-params(3))/T(4)));
g1(5,27)=1;
g1(5,28)=(-(y(31)*(-y(30))));
g1(5,30)=(-((1-y(28))*y(31)));
g1(5,31)=(-((1-y(28))*y(30)));
g1(6,29)=1;
g1(6,3)=(-((-(T(4)*y(30)))/(y(3)*y(3))));
g1(6,30)=(-(T(4)/y(3)));
g1(7,28)=1;
g1(7,29)=(-(params(9)*2*(y(29)-1-T(1))));
g1(8,29)=(-(2*params(9)));
g1(8,32)=1;
g1(9,24)=(-((1-params(6))/T(8)));
g1(9,95)=T(55)/(T(4)*y(96)-y(25)*params(7));
g1(9,1)=(-((-((1-params(6))*y(24)*T(56)))/(T(8)*T(8))));
g1(9,25)=(-((-((1-params(6))*y(24)))/(T(8)*T(8))-(-(T(11)*(-params(7))))/T(59)));
g1(9,96)=(-(T(4)*T(11)))/T(59);
g1(9,33)=1;
g1(10,33)=(-(y(92)/(y(33)*y(33))));
g1(10,34)=1;
g1(10,92)=(-(T(53)/y(33)));
g1(11,33)=(-(y(36)*y(101)*T(68)));
g1(11,100)=(-(y(36)*y(101)*T(69)));
g1(11,36)=(-(y(101)*T(3)));
g1(11,101)=(-(y(36)*T(3)));
g1(12,28)=(-(y(31)*(-y(38))));
g1(12,29)=(-(y(31)*y(38)*(-y(32))));
g1(12,97)=(-(y(98)*T(3)*y(102)*y(99)*2*y(97)));
g1(12,31)=(-(y(38)*(1-y(28)-y(29)*y(32))));
g1(12,98)=(-T(13));
g1(12,32)=(-(y(31)*y(38)*(-y(29))));
g1(12,99)=(-(y(98)*T(3)*y(102)*T(12)));
g1(12,33)=(-(y(98)*T(12)*y(99)*y(102)*T(68)));
g1(12,100)=(-(y(98)*T(12)*y(99)*y(102)*T(69)));
g1(12,38)=(-(y(31)*(1-y(28)-y(29)*y(32))));
g1(12,102)=(-(y(98)*T(12)*T(3)*y(99)));
g1(13,37)=1;
g1(13,7)=(-(1/y(40)));
g1(13,40)=(-((-y(7))/(y(40)*y(40))));
g1(14,24)=(-((-(1-params(6)))*T(14)));
g1(14,26)=(-(y(24)*(-(1-params(6)))*T(63)));
g1(14,92)=1;
g1(15,40)=(-(T(4)*y(42)/y(9)));
g1(15,41)=1;
g1(15,9)=(-(y(40)*(-(T(4)*y(42)))/(y(9)*y(9))));
g1(15,42)=(-(y(40)*T(4)/y(9)));
g1(16,33)=(-(y(105)*T(18)*T(4)*params(11)*T(68)));
g1(16,100)=(-(y(105)*T(18)*T(4)*params(11)*T(69)));
g1(16,34)=(-(y(45)*T(15)*y(44)));
g1(16,40)=(-(y(105)*T(3)*T(4)*params(11)*T(83)));
g1(16,104)=(-(y(105)*T(3)*T(4)*params(11)*T(101)/T(17)));
g1(16,43)=1;
g1(16,105)=(-(T(3)*T(4)*params(11)*T(18)));
g1(16,44)=(-(y(34)*T(15)*y(45)));
g1(16,45)=(-(y(34)*T(15)*y(44)));
g1(17,33)=(-(y(106)*T(21)*params(11)*T(68)));
g1(17,100)=(-(y(106)*T(21)*params(11)*T(69)));
g1(17,40)=(-(y(106)*T(3)*params(11)*T(87)));
g1(17,103)=(-(y(106)*T(3)*params(11)*T(95)));
g1(17,104)=(-(y(106)*T(3)*params(11)*T(101)/T(20)));
g1(17,44)=T(53);
g1(17,46)=1;
g1(17,106)=(-(T(3)*params(11)*T(21)));
g1(18,42)=(-((-(y(43)*y(46)))/(y(42)*y(46)*y(42)*y(46))));
g1(18,43)=(-(1/(y(42)*y(46))));
g1(18,46)=(-((-(y(42)*y(43)))/(y(42)*y(46)*y(42)*y(46))));
g1(18,47)=1;
g1(19,8)=(-(params(11)*T(72)*T(73)));
g1(19,41)=(-(params(11)*T(73)*(-T(22))/(y(41)*y(41))));
g1(19,47)=(-((1-params(11))*getPowerDeriv(y(47),1-params(5),1)));
g1(20,8)=(-(y(11)*params(11)*T(75)/(T(25)*T(25))));
g1(20,41)=(-(y(11)*params(11)*T(100)/T(25)));
g1(20,47)=(-((1-params(11))*getPowerDeriv(y(47),(-params(5)),1)));
g1(20,11)=(-(params(11)*T(24)/T(25)));
g1(20,48)=1;
g1(21,2)=(-(T(26)*T(65)));
g1(21,44)=(-(T(28)*y(50)*T(104)));
g1(21,49)=1;
g1(21,50)=(-(T(28)*y(44)*T(104)));
g1(22,42)=1;
g1(22,44)=(-((-(y(49)*params(2)*y(51)))/(y(44)*y(44))));
g1(22,49)=(-(params(2)*y(51)/y(44)));
g1(22,51)=(-(y(49)*params(2)/y(44)));
g1(23,2)=(-((-(y(49)*(1-params(2))*y(51)*T(64)))/(T(27)*T(27))));
g1(23,35)=1;
g1(23,49)=(-((1-params(2))*y(51)/T(27)));
g1(23,51)=(-(y(49)*(1-params(2))/T(27)));
g1(24,51)=T(53);
g1(24,52)=1;
g1(25,33)=(-(y(107)*T(33)*T(4)*params(10)*T(68)));
g1(25,100)=(-(y(107)*T(33)*T(4)*params(10)*T(69)));
g1(25,40)=(-(y(107)*T(3)*T(4)*params(10)*T(90)));
g1(25,103)=(-(y(107)*T(3)*T(4)*params(10)*T(97)));
g1(25,52)=(-(T(30)*y(55)));
g1(25,53)=1;
g1(25,107)=(-(T(3)*T(4)*params(10)*T(33)));
g1(25,54)=(-(y(55)*y(52)*T(29)));
g1(25,55)=(-(y(52)*T(30)));
g1(26,33)=(-(y(108)*T(36)*T(4)*params(10)*T(68)));
g1(26,100)=(-(y(108)*T(36)*T(4)*params(10)*T(69)));
g1(26,40)=(-(y(108)*T(3)*T(4)*params(10)*T(93)));
g1(26,103)=(-(y(108)*T(3)*T(4)*params(10)*T(99)));
g1(26,54)=T(53);
g1(26,56)=1;
g1(26,108)=(-(T(3)*T(4)*params(10)*T(36)));
g1(27,53)=(-(1/y(56)));
g1(27,56)=(-((-y(53))/(y(56)*y(56))));
g1(27,57)=1;
g1(28,8)=(-(params(10)*T(77)*T(78)));
g1(28,40)=(-(params(10)*T(78)*(-T(37))/(y(40)*y(40))));
g1(28,57)=(-((1-params(10))*getPowerDeriv(y(57),1-params(4),1)));
g1(29,8)=(-(y(15)*params(10)*T(80)/(T(40)*T(40))));
g1(29,40)=(-(y(15)*params(10)*T(94)/T(40)));
g1(29,57)=(-((1-params(10))*getPowerDeriv(y(57),(-params(4)),1)));
g1(29,15)=(-(params(10)*T(39)/T(40)));
g1(29,58)=1;
g1(30,7)=(-(params(17)*T(70)/T(42)));
g1(30,39)=T(70)/T(41);
g1(30,40)=(-((1-params(17))*params(18)*1/(steady_state(19))/T(43)));
g1(30,13)=(-((1-params(17))*params(20)*T(105)/T(45)));
g1(30,54)=(-((1-params(17))*(params(19)*1/(steady_state(33))/T(44)+params(20)*T(106)/T(45))));
g1(30,59)=(-(1/y(59)));
g1(31,25)=T(53);
g1(31,30)=T(53);
g1(31,54)=1;
g1(31,60)=T(53);
g1(32,26)=1;
g1(32,44)=(-y(48));
g1(32,48)=(-y(44));
g1(33,49)=1;
g1(33,54)=(-y(58));
g1(33,58)=(-y(54));
g1(34,35)=(-(1/y(6)));
g1(34,6)=(-((-(y(35)+(1-params(3))*y(38)))/(y(6)*y(6))));
g1(34,38)=(-((1-params(3))/y(6)));
g1(34,61)=1;
g1(35,37)=1;
g1(35,61)=T(53);
g1(35,62)=1;
g1(36,35)=(-(1/y(18)));
g1(36,18)=(-((-(y(35)+(1-params(3))*y(64)))/(y(18)*y(18))));
g1(36,64)=(-((1-params(3))/y(18)));
g1(36,68)=1;
g1(37,38)=(-((-(y(64)*y(66)*y(65)))/(y(38)*y(65)*y(38)*y(65))));
g1(37,64)=(-(y(66)/(y(38)*y(65))));
g1(37,65)=(-((-(y(38)*y(64)*y(66)))/(y(38)*y(65)*y(38)*y(65))));
g1(37,66)=(-(y(64)/(y(38)*y(65))));
g1(37,69)=1;
g1(38,69)=(-((1+y(70))*y(73)));
g1(38,70)=y(71)-(y(72)+y(69)*y(73));
g1(38,71)=y(70);
g1(38,72)=(-(1+y(70)));
g1(38,73)=(-(y(69)*(1+y(70))));
g1(39,70)=y(74)-y(73);
g1(39,73)=(-(1+y(70)));
g1(39,74)=y(70);
g1(40,69)=(-((-(y(76)*(-y(73))))/T(107)));
g1(40,71)=(-((-y(76))/T(107)));
g1(40,72)=(-(y(76)/T(107)));
g1(40,73)=(-((-(y(76)*(-y(69))))/T(107)));
g1(40,75)=1;
g1(40,76)=(-(1/(y(71)-(y(72)+y(69)*y(73)))));
g1(41,33)=(-(y(101)*y(112)*T(68)));
g1(41,100)=(-(y(101)*y(112)*T(69)));
g1(41,101)=(-(T(3)*y(112)));
g1(41,76)=1;
g1(41,112)=(-(y(101)*T(3)));
g1(42,33)=(-((y(109)-y(101))*y(112)*T(68)));
g1(42,100)=(-((y(109)-y(101))*y(112)*T(69)));
g1(42,101)=T(3)*y(112);
g1(42,109)=(-(T(3)*y(112)));
g1(42,72)=1;
g1(42,112)=(-(T(3)*(y(109)-y(101))));
g1(43,33)=(-((y(101)-y(111))*y(112)*T(68)));
g1(43,100)=(-((y(101)-y(111))*y(112)*T(69)));
g1(43,101)=(-(T(3)*y(112)));
g1(43,111)=T(3)*y(112);
g1(43,73)=1;
g1(43,112)=(-(T(3)*(y(101)-y(111))));
g1(44,71)=(-(y(75)*params(28)));
g1(44,75)=(-(y(71)*params(28)));
g1(44,77)=1;
g1(45,38)=y(65);
g1(45,64)=(-y(66));
g1(45,65)=y(38);
g1(45,66)=(-y(64));
g1(45,67)=T(53);
g1(45,78)=T(53);
g1(46,78)=1;
g1(46,79)=T(53);
g1(46,80)=T(53);
g1(47,35)=(-(T(46)*(y(19)-y(20))));
g1(47,37)=(-(T(46)*(-y(21))));
g1(47,38)=(-(T(46)*(1-params(3))*y(19)));
g1(47,64)=(-(T(46)*(-((1-params(3))*y(20)))));
g1(47,19)=(-((y(35)+(1-params(3))*y(38))*T(46)));
g1(47,20)=(-(T(46)*(-(y(35)+(1-params(3))*y(64)))));
g1(47,21)=(-(T(46)*(-y(37))));
g1(47,79)=1;
g1(48,35)=(-(y(65)*T(47)));
g1(48,38)=(-(y(65)*(1-params(3))*T(47)));
g1(48,65)=(-((y(35)+(1-params(3))*y(38))*T(47)));
g1(48,80)=1;
g1(48,81)=(-(y(65)*(y(35)+(1-params(3))*y(38))*T(64)));
g1(49,38)=(-(y(65)/y(78)));
g1(49,65)=(-(y(38)/y(78)));
g1(49,75)=1;
g1(49,78)=(-((-(y(38)*y(65)))/(y(78)*y(78))));
g1(50,33)=(-(y(111)*T(68)));
g1(50,100)=(-(y(111)*T(69)));
g1(50,111)=(-T(3));
g1(51,27)=T(53);
g1(51,65)=1;
g1(52,69)=(-(y(82)*(params(31)+y(83)*2*y(69)/2)));
g1(52,71)=1;
g1(52,82)=(-T(49));
g1(52,83)=(-(y(82)*T(48)/2));
g1(53,69)=(-(y(82)*y(83)));
g1(53,74)=1;
g1(53,82)=(-(params(31)+y(69)*y(83)));
g1(53,83)=(-(y(69)*y(82)));
g1(54,12)=(-(params(21)*1/y(12)));
g1(54,50)=1/y(50);
g1(54,113)=T(53);
g1(55,17)=(-(params(22)*1/y(17)));
g1(55,60)=1/y(60);
g1(55,114)=T(53);
g1(56,14)=(-(params(23)*1/y(14)));
g1(56,55)=1/y(55);
g1(56,115)=T(53);
g1(57,10)=(-(params(24)*1/y(10)));
g1(57,45)=1/y(45);
g1(57,118)=T(53);
g1(58,4)=(-(params(27)*1/y(4)));
g1(58,31)=1/y(31);
g1(58,117)=T(53);
g1(59,16)=(-(params(25)*1/y(16)));
g1(59,59)=1/y(59);
g1(59,116)=T(53);
g1(60,5)=(-(params(26)*1/y(5)));
g1(60,36)=1/y(36);
g1(60,119)=T(53);
g1(61,13)=(-(T(4)*T(105)/(T(4)*T(45))));
g1(61,54)=(-(T(4)*T(106)/(T(4)*T(45))));
g1(61,84)=1;
g1(62,1)=(-(T(58)/T(50)));
g1(62,25)=(-(T(60)/T(50)));
g1(62,85)=1;
g1(63,3)=(-(T(66)/T(51)));
g1(63,30)=(-(T(67)/T(51)));
g1(63,90)=1;
g1(64,9)=(-(T(102)/T(52)));
g1(64,42)=(-(T(103)/T(52)));
g1(64,91)=1;
g1(65,44)=(-(1/(steady_state(23))));
g1(65,88)=1;
g1(66,39)=T(53);
g1(66,87)=1;
g1(67,40)=(-(1/y(40)));
g1(67,86)=1;
g1(68,62)=T(53);
g1(68,89)=1;
g1(69,82)=1;
g1(70,81)=1;
g1(71,83)=1;

end
